/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.gui;

import codechicken.lib.vec.Rectangle4i;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import morph.avaritia.client.gui.DrawableElement;
import morph.avaritia.client.gui.Point;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class AnimScreenBase<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private final List<DrawableElement> elements = new LinkedList<DrawableElement>();
    private ResourceLocation backgroundTex;

    public AnimScreenBase(T container, Inventory playerInv, Component title) {
        super(container, playerInv, title);
    }

    protected void setBackgroundTexture(ResourceLocation location) {
        this.backgroundTex = location;
    }

    protected void m_7025_(PoseStack pStack, int mouseX, int mouseY) {
        super.m_7025_(pStack, mouseX, mouseY);
        if (this.f_97732_.m_142621_().m_41619_()) {
            pStack.m_85836_();
            for (DrawableElement element : this.elements) {
                if (!element.getBounds().offset(this.f_97735_, this.f_97736_).contains(mouseX, mouseY)) continue;
                element.drawTooltip(pStack, mouseX, mouseY);
            }
            pStack.m_85849_();
        }
    }

    protected void m_7286_(PoseStack pStack, float partialTicks, int mouseX, int mouseY) {
        pStack.m_85836_();
        pStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        for (DrawableElement element : this.elements) {
            element.draw(pStack);
        }
        pStack.m_85849_();
    }

    protected DrawableBuilder addDrawable() {
        return new DrawableBuilder().parent((Screen)this).spriteSheet(this.backgroundTex).animationDirection(DrawableElement.AnimationDirection.STATIC);
    }

    protected void drawBackground(PoseStack pStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTex);
        this.m_93228_(pStack, this.f_97735_, (this.f_96544_ - this.f_97727_) / 2, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected class DrawableBuilder {
        private Screen parent;
        private ResourceLocation spriteLocation;
        private Rectangle4i sprite;
        private Point location;
        private BooleanSupplier renderPredicate;
        private DoubleSupplier animSupplier;
        private DrawableElement.AnimationDirection animDirection;
        private Supplier<Component> tooltipSupplier;

        public DrawableBuilder parent(Screen parent) {
            this.parent = parent;
            return this;
        }

        public DrawableBuilder spriteSheet(ResourceLocation spriteLocation) {
            this.spriteLocation = spriteLocation;
            return this;
        }

        public DrawableBuilder size(int x, int y, int w, int h) {
            return this.size(new Rectangle4i(x, y, w, h));
        }

        public DrawableBuilder size(Rectangle4i sprite) {
            this.sprite = sprite;
            return this;
        }

        public DrawableBuilder location(int x, int y) {
            return this.location(new Point(x, y));
        }

        public DrawableBuilder location(Point location) {
            this.location = location;
            return this;
        }

        public DrawableBuilder progressSupplier(DoubleSupplier animSupplier) {
            this.animSupplier = animSupplier;
            return this;
        }

        public DrawableBuilder animationDirection(DrawableElement.AnimationDirection animDirection) {
            this.animDirection = animDirection;
            return this;
        }

        public DrawableBuilder renderPredicate(BooleanSupplier renderPredicate) {
            this.renderPredicate = renderPredicate;
            return this;
        }

        public DrawableBuilder tooltipSupplier(Supplier<Component> tooltipSupplier) {
            this.tooltipSupplier = tooltipSupplier;
            return this;
        }

        public void add() {
            Objects.requireNonNull(this.parent, "parent required");
            Objects.requireNonNull(this.spriteLocation, "spriteLocation required");
            Objects.requireNonNull(this.sprite, "sprite required");
            Objects.requireNonNull(this.location, "location required");
            Objects.requireNonNull(this.animSupplier, "animSupplier required");
            Objects.requireNonNull(this.animDirection, "animDirection required");
            Objects.requireNonNull(this.renderPredicate, "renderPredicate required");
            AnimScreenBase.this.elements.add(new DrawableElement(this.parent, this.spriteLocation, this.sprite, this.location, this.animSupplier, this.animDirection, this.renderPredicate, this.tooltipSupplier));
        }
    }
}

